#class_name PlayerSettings
extends Container

signal value_changed(Transform3D)

@export var offset_x: SpinBox
@export var offset_y: SpinBox
@export var offset_z: SpinBox

@export var rotation_x: SpinBox
@export var rotation_y: SpinBox
@export var rotation_z: SpinBox

@export var scale_xyz: SpinBox

func set_nickname(value: String) -> void:
	$Nickname.text = value

func on_transform_changed(value: Transform3D) -> void:
	offset_x.set_value_no_signal(value.origin.x)
	offset_y.set_value_no_signal(value.origin.y)
	offset_z.set_value_no_signal(value.origin.z)

	var rot := value.basis.get_euler()
	rotation_x.set_value_no_signal(rad_to_deg(rot.x))
	rotation_y.set_value_no_signal(rad_to_deg(rot.y))
	rotation_z.set_value_no_signal(rad_to_deg(rot.z))

	scale_xyz.set_value_no_signal(value.basis.get_scale().x)

func _on_value_changed(_value: float) -> void:
	var origin := Vector3(offset_x.value, offset_y.value, offset_z.value)
	var rot    := Vector3(rotation_x.value, rotation_y.value, rotation_z.value) / 360 * TAU
	var basis  := Basis.from_euler(rot) * Basis.from_scale(Vector3.ONE * scale_xyz.value)
	value_changed.emit(Transform3D(basis, origin))

	# Ensure that rotation inputs are always in 0-359 range.
	rotation_x.set_value_no_signal(fposmod(rotation_x.value, 360))
	rotation_y.set_value_no_signal(fposmod(rotation_y.value, 360))
	rotation_z.set_value_no_signal(fposmod(rotation_z.value, 360))
