#class_name copyMultiplayerSettings
extends TabContainer

@export var visible_icon : Texture2D
@export var hidden_icon  : Texture2D

@export var connect_address    : LineEdit
@export var connect_reveal     : Button
@export var connect_port       : SpinBox
@export var connect_join       : Button
@export var connect_host       : Button
@export var connect_disconnect : Button

@export var settings_cache       : LineEdit
@export var settings_file_dialog : FileDialog
@export var settings_nickname    : LineEdit

func is_tab_selected(tab_name: String) -> bool:
	return get_current_tab_control().name == tab_name

func _on_cache_dir_dialog_pressed() -> void:
	settings_file_dialog.size = get_window().size / 2
	settings_file_dialog.position = get_window().size / 4
	settings_file_dialog.current_dir = settings_cache.text
	settings_file_dialog.popup()

	settings_cache.text = await settings_file_dialog.dir_selected
	settings_cache.text_changed.emit(settings_cache.text)

func _on_show_hide_address_toggled(toggled_on: bool) -> void:
	connect_address.secret = !toggled_on
	connect_reveal.icon = visible_icon if toggled_on else hidden_icon
