#class_name PlayerStats
extends Container

var history: Array[Dictionary] = []
var ping := 0

func set_nickname(value: String) -> void:
	$Nickname.text = value

func set_ping(value: int) -> void:
	$Ping.text = str(value) + " ms"
	ping = value

# Called when model animation is sent / received.
func push(buffer_size: int) -> void:
	history.append({
		time = Time.get_ticks_msec(),
		size = buffer_size,
	})

func _process(_delta: float) -> void:
	var now := Time.get_ticks_msec()
	while history.size() > 0 && now > history[0].time + 1000:
		history.pop_front()

	var total   := 0
	var maximum := 0
	for entry in history:
		total += entry.size
		maximum = maxi(maximum, entry.size)

	$Average.text = "%.1f kB/s" % (float(total) / 1000)
	$Maximum.text = "%d bytes" % maximum
